﻿/* Skript zur Demonstration von Regulären Ausdrücken
 * Als Benutzer SCOTT ausführen
 */

-- Prüfung einer Email, erster Versuch
select 'Gültige Emailadresse' test_ergebnis
  from dual
 where regexp_like('info@foo.de', '@');
 
-- Einschränkung auf eine zweistellige Länderdomäne
select 'Gültige Emailadresse' test_ergebnis
  from dual
 where regexp_like('info@foo.de', '@[a-z]+\.[a-z]{2}$');
 
-- Erweiterung um weitere Domänen, Verwendung von Klassen
select 'Gültige Emailadresse' test_ergebnis
  from dual
 where regexp_like('info@foo.3-mail.com', 
         '@([[:alnum:]-]+\.)+([[:alpha:]]{2}|com|museum)$');

--Erweiterung um einen Test für den local-part
set define off
select 'Gültige Emailadresse' test_ergebnis
  from dual
 where regexp_like('inf.a23#me&you@foo.de', 
         '^([[:alnum:]([%!#$%&*+=?^_`{|}~&)])+(\.?([[:alnum:]([%!#$%&*+=?^_`{|}~&)])+)*@([[:alnum:]]?([[:alnum:]-]*[[:alnum:]])?\.)+([[:alpha:]]{2}|com|org|net|edu|gov|mil|biz|info|mobi|name|aero|asia|jobs|museum)$');


-- Die Verwendung der Funktion REGEXP_COUNT !#$%&*+=?^_`{|}~
select regexp_count(
         'Wer erkennt jedermannes Wert?',
         'er', 2) resultat
  from dual;

-- Die Verwendung der Funktion REGEXP_INSTR
select regexp_instr(
         'Das ist ein Text, ein Text in dem ich etwas suche',
         '[r|s|t][[:alpha:]]{3}', 3, 2, 1, 'i') ausdruck
from dual;

-- Verwendung der Funktion REGEXP_REPLACE
select regexp_replace(
         'Das ist ein Text, ein Text in dem ich etwas suche',
         ' ein [r|s|t][[:alpha:]]{3}', '', 1, 2, 'i') ausdruck
from dual;

-- Verwendung der Funktion REGEXP_SUBSTR
select regexp_substr(
         'Das ist ein Text, ein Text in dem ich etwas suche',
         ' ein [r|s|t][[:alpha:]]{3}', 1, 2, 'i') ausdruck
from dual;